/*
 * ECE3884 Lab05
 * Georgia Institute of Technology
 * Your Name: 
 */

//------------------------------------------------------------------------------
//         Headers
//------------------------------------------------------------------------------

#include <board.h>
#include <pio/pio.h>
#include <dbgu/dbgu.h>
#include <tc/tc.h>
#include <utility/math.h>
#include <stdio.h>

//------------------------------------------------------------------------------
//         Local variables
//------------------------------------------------------------------------------

/// Pio pins to configure.
static const Pin pins[] = {PINS_DBGU};

//------------------------------------------------------------------------------
//         Global functions
//------------------------------------------------------------------------------
#define ARRAY_SIZE 500
#define ARRAY_TYPE int //Test both int and char
#define ARRAY_TYPE_BITS 4*sizeof(ARRAY_TYPE)
#define REPEATS 1000

ARRAY_TYPE array[ARRAY_SIZE];

int main(void)
{
    char TC0_Clock_Source;
    unsigned int i, sum, repeat, startCounts, stopCounts, elapsedCounts, modulus;
    modulus = power(2,ARRAY_TYPE_BITS);
      
    PIO_Configure(pins, PIO_LISTSIZE(pins));
    DBGU_Configure(DBGU_STANDARD, 115200, BOARD_MCK);
    printf("-- lab05 --\n\r");

    // Turn on TC0
    AT91C_BASE_PMC->PMC_PCER = 1 << AT91C_ID_TC0; 

    // TC0_Clock_Source:
    // 1: MCK/2
    // 2: MCK/8
    // 3: MCK/32
    // 4: MCK/128
    // 5: MCK/1024
    TC0_Clock_Source = 4;
    TC_Configure(AT91C_BASE_TC0, TC0_Clock_Source);
    TC_Start(AT91C_BASE_TC0);
    
    // Fill array with some values
    for (i = 0; i < ARRAY_SIZE; i++)
    {
        array[i] = i % modulus;
    }
    
    sum = 0;
    // Read the current timer counts
    startCounts = AT91C_BASE_TC0->TC_CV;
    for(repeat = 0; repeat < REPEATS; repeat++)
    {
        for(i = 0; i < ARRAY_SIZE; i++) // inner loop
        {
            sum += array[i];
        }
    }
    // Read the current timer counts again
    stopCounts = AT91C_BASE_TC0->TC_CV;
    
    // Did the timer overflow?
    if(AT91C_BASE_TC0->TC_SR & AT91C_TC_COVFS)
    {
        // If timer overflows, slow it down by increasing TC0_Clock_Source
        printf("Timer Overflowed...\r\n");
        while(1);
    }
    else
    {
       elapsedCounts = stopCounts - startCounts;
    }
    printf("ARRAY_SIZE = %u\r\n",(unsigned int) ARRAY_SIZE);
    printf("elapsedCounts = %u\r\n",elapsedCounts);        
    // Round Counts per loop to nearest integer
    printf("Counts per loop = %u\r\n",(elapsedCounts+REPEATS/2)/REPEATS); 

    // Program is finished, 
    while(1);    
}

